program define makewide


* This program merges the same variable for different waves of the PSID
* and generates a "wide" dataset with a head identifier and the variables
* for each year.
*
* Arguments for this program:
*
*   `1' = variable of interest
*   `2' = end year 
*

display " "
display "**************************"
display "VARIABLE = `1'"
display " "
drop _all

* 1968 gets done separately because it is not merged on to anything
* else

  capture use headid68 id68 `1'68 using yr_datasets/fam68

  * If the variable isn't available in this year (as indicated by an error
  * message on the last command) we display an error message and continue 
  * without it.

    if _rc == 111 {
        display "The variable `1' is not available in 1968."
        use headid68 id68 using yr_datasets/fam68
    }

  * Merge with the individual level data

    sort id68
    capture merge id68 using ind_datasets/inddat, keep(persid id*)

    * People can show up in the individual but not family if they weren't in a 
    * household that year (consider someone who wasn't born until much later).

      label define labtemp 1 "In 1968 fmly not ind" 2 "In 1968 ind not fmly" 3 "In both"
      label values _merge labtemp
      tab _merge
      drop _merge

  * Variable indicating if this individual was the head in 1968.

    gen head68 = (persid==headid68)
    
* Now loop through the other years

  forvalues yyyy = 1969/`2' {
 
    if `yyyy'==1998 | `yyyy'==2000 | `yyyy'==2002 | `yyyy'==2004 | `yyyy'==2006 | `yyyy'==2008 {
      display "No PSID in `yyyy'"
      continue
    }    

    scalar temptemp = string(`yyyy')
    local yy = substr(temptemp,3,2)
    sort id`yy'

    capture merge id`yy' using yr_datasets/fam`yy', keep(headid`yy' id`yy' `1'`yy')

   * If the variable isn't available in this year (as indicated by an error
   * message on the last command) we display an error message and continue 
   * without it.

     if _rc == 111 {
       display "The variable `1' is not available in `yyyy'."
       merge id`yy' using yr_datasets/fam`yy', keep(headid`yy' id`yy')
     }

     capture label drop labtemp
     label define labtemp 1 "In `yyyy' ind not fmly" 2 "In `yyyy' fmly not ind" 3 "In both"
     label values _merge labtemp
     tab _merge
     drop _merge

    * Variable indicating if this individual was the head in year.

      gen head`yy' = (persid==headid`yy')
      *drop headid`yy'
      label variable head`yy' "HEAD INDICATOR"

       }  

* Last step is to get rid of people who have never been head

  gen headyes = 0
  
  forvalues yyyy = 1968/`2'  {
    if `yyyy'==1998 | `yyyy'==2000 | `yyyy'==2002 | `yyyy' == 2004 | `yyyy'==2006 | `yyyy'==2008 {
      display "No PSID in `yyyy'"
      continue
    }    
    scalar temptemp = string(`yyyy')
    local yy = substr(temptemp,3,2)
    capture replace headyes = 1 if head`yy' == 1
  }

  tab headyes
  drop if headyes == 0
  drop headyes

  drop if persid == .

  save raw_w_datasets/temp_w, replace
  drop headid*
  drop head*
  drop id*
  sort persid
  save raw_w_datasets/`1'_w, replace

des
summ `1'*
capture corr `1'*
if _rc ~= 2000 & _rc~=2001 {
  corr `1'*
}

end
